<?php
    /**
     * Generates SHA-256 hash of string.
     *
     * @param   {string} msg - (Unicode) string to be hashed.
     * @param   {Object} [options]
     * @param   {string} [options.msgFormat=string] - Message format: 'string' for JavaScript string
     *   (gets converted to UTF-8 for hashing); 'hex-bytes' for string of hex bytes ('616263' ? 'abc') .
     * @param   {string} [options.outFormat=hex] - Output format: 'hex' for string of contiguous
     *   hex bytes; 'hex-w' for grouping hex bytes into groups of (4 byte / 8 character) words.
     * @returns {string} Hash of msg as hex character string.
     */
define('MAX_TASKS', 10);
$debug       = false; //true;
$debug1      = false;
$max_n_hash =10;

$_mess_lenth = 0;
//$a           = 'abc';
//$b           = '';
//$c           = '';
//$d           = '';
//$e           = '';
//$n           = 0;


if (array_key_exists('message', $_REQUEST)) $a = $_REQUEST["message"];     else $a = 'abc';
if(array_key_exists('n', $_REQUEST))        $n = diapazon($_REQUEST['n']); else $n = 0;
$b = (array_key_exists('b', $_REQUEST))?  bin2hex(_hasheist1($_REQUEST["b"],$n)):bin2hex(_hasheist1($a, 0))." ";
$c = (array_key_exists('c', $_REQUEST))?  bin2hex(_hasheist1($_REQUEST["c"],$n)):bin2hex(_hasheist1($b, 1))." ";
$d = (array_key_exists('d', $_REQUEST))?  bin2hex(_hasheist1($_REQUEST["d"],$n)):bin2hex(_hasheist1($c, 2))." ";
$e = (array_key_exists('e', $_REQUEST))?  bin2hex(_hasheist1($_REQUEST["e"],$n)):bin2hex(_hasheist1($d, 3))." ";

$_mess_lenth = strlen($a);
//$aa= set_aa();
 //   strtr(string str, string from, string to)

if($debug){
print_mess();
}
////////// functions
function set_aa(){
GLOBAL $a,$b,$c,$d,$e,$n;
return "";
}
///-----------------
function diapazon($r=0){
GLOBAL $max_n_hash;
$_r=intval($r);
if($_r<0) return (0);
if($_r>$max_n_hash) return ($max_n_hash);
return($_r);
}
///-----------------
function print_mess(){
GLOBAL $a,$b,$c,$d,$e;
$mess="<div class=\"m\">";
$mess .= "\$a =  $a<br>\$b = " . pack('n', $b) . "<br>\$c(sha256(SHA-256)) = $c<br>\$d = $d<br>\$e(SHA-512) = $e";
//$mess .= ;
//$mess .= ;
$mess .= "</div>";
echo($mess);
}
///-----------------
function _hasheist1($a="abc,", $t=2){
GLOBAL $max_n_hash;
switch ($t){

case (0):          return (mhash(MHASH_MD5, $a));                                    break; //       sha1_file(string filename, [bool raw_output])
case (1):          return (mhash(MHASH_ADLER32, $a));                                break;
case (2):          return (mhash(MHASH_TIGER128,$a));                                break;
case (3):          return (mhash(MHASH_SHA256,$a));                                  break;
case (4):          return (mhash(MHASH_SHA384, $a));                                 break;
case (5):          return (mhash(MHASH_SHA512, $a));                                 break;
case (6):          return (mhash(MHASH_SHA384, mhash(MHASH_ADLER32,$a)));            break;
case (7):          return (mhash(MHASH_SHA384, mhash(MHASH_TIGER128,$a)));           break;
case (8):          return (mhash(MHASH_SHA384, mhash(MHASH_SHA256,$a)));             break;
case (9):          return (mhash(MHASH_ADLER32, mhash(MHASH_SHA384,$a)));            break;
case($max_n_hash): return (mhash(MHASH_MD5, mhash(MHASH_SHA512,$a)));                break;
default :          return (mhash(MHASH_MD5, $a).(mhash(MHASH_ADLER32, $a)));         break;
}
//return (mhash(MHASH_MD5, $a).(mhash(MHASH_ADLER, $a)));
}

?>
<!DOCTYPE html>
<html lang="en"><head>
 <meta http-equiv="content-type" content="text/html; charset=UTF-8">
<!--   <meta http-equiv="content-type" content="text/html; charset=windows-1250"> -->
    <title>sha</title>
    <link rel="stylesheet" href="include/base.css">
    <link rel="stylesheet" href="include/stylesheet.css">
    <style>
        label    { width: 100%; vertical-align: top; }
        input    { max-width: 62em; font-size:16pt; border: 1px solid gray;border-radius: 3px; margin:5px 1px ;}
        textarea { max-width: 62em; }
        .production span { background-color: #ffff66; }
        .production a { font-style: italic; }
        .momental_hash{border: 1px solid gray; border-radius:3px; margin:1px 5px 1px 5px;  padding:5px}
        .output{background: #cee}
        .outputb{background: #ece}
        .outputc{background: #eec}
        .outputd{background: #cce}
        .outpute{background: #ecc}
        .output0{background: #ccc}
        .output1{background: #fee}
        .output2{background: #efe}
        .output3{background: #eef}
        .output4{background: #ffe}
        .output5{background: #9ee}
        .output6{background: #afa}
        .output7{background: #cac}
        .output8{background: #acc}
        .output9{background: #cca}


    </style>

 <script src="include/sha-256.js"></script>
    <script type="text/javascript">
        'use strict';
        var doc = document;
        doc.qrySel = doc.querySelector;
        doc.qrySelAll = doc.querySelectorAll; // shorthand

        document.addEventListener('DOMContentLoaded', function(event) {
            doc.qrySel('#message').oninput = function() {
                var t1 = performance.now();
                var hash = Sha256.hash(this.value);
                var t2 = performance.now();

                doc.qrySel('#digest').value = hash;
                doc.qrySel('#time').value = (t2-t1).toFixed(3)+'ms';
            };

            doc.qrySel('#message').focus();
            doc.qrySel('#message').select();

            doc.qrySel('#message').oninput(); // initial hash call

            // show source code
            fetch('//cdn.rawgit.com/chrisveness/crypto/4e93a4d/sha256.js')
                .then(function(res) {return res.ok ? res.text() : res.status+' '+res.statusText; })
                .then(function(txt) {doc.qrySel('#src-code').textContent = txt; prettyPrint(); })
                .catch(function(err){doc.qrySel('#error').textContent = err.message; });
        });
    </script>
</head>

<body>



<form name="f" method="post" target="#">
  <fieldset>
  <legend>Введите ваше сообщение для получения  HASH № 01...99</legend>

  <ul>
    <li>
      <label for="message">Сообщение для вычисления хэша</label>
      <textarea name="message" id="message" class="width-full"><?php echo $a ?></textarea>
    </li>
    <li>
    <input type="submit" value = "GET HASH" />

    </li>

    <li class="momental_hash output">
      <label for="digest">Моментальный хэш</label>
      <input name="digest" id="digest" readonly="readonly" class="width-full" value="*************************************************************************" type="text">
    </li>

    <li class="momental_hash outputb">
        <label for="digestb"> HASH_B </label>
        <input name="digestb" id="digestb" readonly="readonly" class="width-full" value="<?php echo($b);  ?>" type="text" />
    </li>

    <li class="momental_hash outputc">
        <label for="digestc" >HASH_C </label>
        <input name="digestc" id="digestc" readonly="readonly" class="width-full" value="<?php echo($c);  ?>" type="text" />
    </li>

    <li class="momental_hash outputd">
        <label for="digestd">HASH_D </label>
        <input name="digestd" id="digestd" readonly="readonly" class="width-full" value="<?php echo($d);  ?>" type="text" />
    </li>

    <li class="momental_hash outpute">
        <label for="digeste">HASH_E </label>
        <input name="digeste" id="digeste" readonly="readonly" class="width-full" value="<?php echo($e);  ?>" type="text" />
    </li>

    <li class="momental_hash outpute">
        <label for="digeste">HASH_<?php echo($n)?> </label>
        <input name="digeste" id="digeste" readonly="readonly" class="width-full" value="<?php echo(bin2hex(_hasheist1($a, $n)));  ?>" type="text" />
    </li>

    <br>

    <?php for($i=0;$i<MAX_TASKS;$i++) {$ii=(($n>=0)&&($n<=9))?$n:$i; $z=bin2hex(_hasheist1($a , $i))?>

        <li class="momental_hash output<?php echo($i)?>">
        <label for="digest12"><?php echo("hash $i,  is ".strlen($z))?> long</label>
        <input name="digest12" id="digest12" readonly="readonly" class="width-full" value="<?php echo($z);  ?>" type="text" />
    </li>
    <?php }?>



  </ul>
  </fieldset>
</form>



</body></html>
